#!/usr/bin/perl -P
#
#~~~~~~~~~~~
#
#	Purpose:	Filtering BAD news articles.
# 	Author:		netman <netmanforever@yahoo.com>
#	Origin:		AcE <ace@coventive.com>
#
#	Version:	1.0.1
#	Date:		2000/10/31
#
#	License:	GNU/GPL <http://www.gnu.org/copyleft/gpl.html>
#
#~~~~~~~~~~~

if ( $ARGV[0] =~ /^$/) {
	printf "ERROR:  missing argument.\n";
	printf "	Syntax: $0 DIR_PATH\n\n";
	exit 1;
}
else { 
	opendir (FDIR, $ARGV[0]) or die "ERROR: Can't open $ARGV[0].\n\n";
	close FDIR;
}

printf "Feltering BAD articles under $ARGV[0] ...\n";

# List for Content filtering
$CList="/var/lib/suck/clist";

# List for 'Subject' filtering
$SList="/var/lib/suck/slist";

# List for 'From' filtering
$FList="/var/lib/suck/flist";

# List for 'Host' filtering
$HList="/var/lib/suck/hlist";

########## Starting Content feltering:
open(cList,"${CList}") or die "Can't open ${CList}.\n";
$index=0;
while(<cList>)
{
  chop;
  $keys[$index]=$_;
  #printf "$keys[$index]\n";
  $index++;
}
close(cList);

for($i=0;$i<$index;$i++){
  $keyword=$keys[$i];
  printf "searching $keyword in Content.\n";
  system("grep -i -r '$keyword' $ARGV[0] > wait4kill-c");

  open(killList,"./wait4kill-c");
  while(<killList>){
    if($_ =~ /^([^:]+):.*$/){
		if($tt ne $1){
	       printf "Deleting $1 ...\n";
		   system("rm -f $1");
		   $tt=$1;
		}
     }

  }
  close(killList);
}
system("rm -f ./wait4kill-c");


########## Starting 'Newsgroups' feltering:
printf "Filtering Newsgroups...\n";
system("grep -r '^Newsgroups.*tw.*tw.*.tw' $ARGV[0] > wait4kill-n");

open(killList,"./wait4kill-n");
	while(<killList>){
     if($_ =~ /^(.+):Newsgroups.*$/){
       printf "Deleting $1 ...\n";
	   system("rm -f $1");
     }
	}
close(killList);
system("rm -f ./wait4kill-n");


########## Starting 'Subject' feltering:
open(sList,"${SList}") or die "Can't open ${SList}.\n";
$index=0;
while(<sList>)
{
  chop;
  $keys[$index]=$_;
  #printf "$keys[$index]\n";
  $index++;
}
close(sList);


for($i=0;$i<$index;$i++){
  $keyword=$keys[$i];
  printf "Searching $keyword in <Subject>\n";
  system("grep -r 'Subject:.*$keyword.*' $ARGV[0] > wait4kill-s");

  open(killList,"./wait4kill-s");
  while(<killList>){
    if($_ =~ /^(.+):Subject:.*$/){
       printf "Deleting $1 ...\n";
	   system("rm -f $1");
    }

  }
close(killList);
}
system("rm -f ./wait4kill-s");

########## Starting 'From' feltering:
open(fList,"${FList}") or die "Can't open ${FList}.\n";
$index=0;
while(<fList>)
{
  chop;
  $keys[$index]=$_;
  #printf "$keys[$index]\n";
  $index++;
}
close(fList);

for($i=0;$i<$index;$i++){
  $keyword=$keys[$i];
  printf "Searching $keyword in <From>\n";
  system("grep -r 'From:.*$keyword.*' $ARGV[0] > wait4kill-f");


  open(killList,"./wait4kill-f");
  while(<killList>){
     if($_ =~ /^(.+):From:.*$/){
       printf "Deleting $1 ...\n";
	   system("rm -f $1");
     }

  }

  close(killList);
}
system("rm -f ./wait4kill-f");

########## Starting 'NNTP-Posting-Host' feltering:
open(hList,"${HList}") or die "Can't open ${HList}.\n";
$index=0;
while(<hList>)
{
  chop;
  $keys[$index]=$_;
  #printf "$keys[$index]\n";
  $index++;
}
close(hList);

for($i=0;$i<$index;$i++){
  $keyword=$keys[$i];
  printf "searching $keyword in <NNTP-Posting-Host>\n";
  system("grep -r 'NNTP-Posting-Host:.*$keyword.*' $ARGV[0] > wait4kill-h");

  open(killList,"./wait4kill-h");
  while(<killList>){
     if($_ =~ /^(.+):NNTP-Posting-Host:.*$/){
       printf "Deleting $1 ...\n";
	   system("rm -f $1");
     }

  }
  close(killList);
}
system("rm -f ./wait4kill-h");
